function [result] = ProbabilityX1LeqX2(deltaX, density1, density2)
% super fast Pr(X1 <= X2) given X1~density1, X2~density2.
% Note: density should be aligned, i.e.  Pr(X1 <= someX) = sum@density1(i),
% Pr(X2 <= the sameX) = sum@density2(same i).

    cdf1 = cumsum(density1) * deltaX;
    result = sum(deltaX * density2 .* cdf1);

end